RequireScript("dialog.js");

function StoryScreen (){

	this.imageArray = [];
	this.text=[];
	this.textpos = 0;
	this.bg=undefined
	this.showText=true;
	this.black = CreateColor(0,0,0,200);
	this.dialog = new DialogObject();
}

StoryScreen.prototype.paint = function(){

	if(this.bg!=undefined)this.bg.blit(0,0);
	for(var i=0;i<this.imageArray.length;i++){
	
		this.imageArray[i][1].blitMask(this.imageArray[i][2],this.imageArray[i][3],this.imageArray[i][5]);
		var da=this.imageArray[i][5].alpha-this.imageArray[i][4];
		
		this.imageArray[i][5].alpha-=da/5;
	}
	
	Rectangle(0,GetScreenHeight()-120,GetScreenWidth(),120,this.black);
	if(this.showText&&this.text.length>0){
		this.text[this.textpos][0].blit(10,GetScreenHeight()-110);
		this.dialog.advancedTextbox(120,GetScreenHeight()-110,GetScreenWidth()-130,this.text[this.textpos][1]+":&n"+this.text[this.textpos][2]+"&q");
		}
	
}

StoryScreen.prototype.increaseCounter = function(){

	this.textpos++;
	this.dialog.popuppos=0;
	this.dialog.blitpos=0;

}

StoryScreen.prototype.addImage = function(id,image,posx,posy,alpha){

	this.imageArray.push([id,image,posx,posy,alpha,CreateColor(255,255,255,0)]);

}

StoryScreen.prototype.setImageAlpha = function(id,alpha){

	for(var i=0;i<this.imageArray.length;i++){
		
			if(this.imageArray[i][0]==id)
				this.imageArray[i][4]=alpha;
		
	}

}

StoryScreen.prototype.setImageOnTop = function(id){

	var arr = [];
	for(var i=0;i<this.imageArray.length;i++){
		
			if(this.imageArray[i][0]!=id)
				arr.unshift(this.imageArray[i]);
			else arr.push(this.imageArray[i]);
		
	}
	
	delete this.imageArray;
	this.imageArray = arr;
}

StoryScreen.prototype.showFrame = function(notext,key,time){

	this.showText=!notext;
	if(time<=0)time=1;	
	var pressed = false;
	while(AreKeysLeft())GetKey();
	
	while(!pressed&&time>0){
			if(key!=undefined){
				if(IsKeyPressed(key))
					pressed=true;
				}
			this.paint();
			FlipScreenFps();
			if(key==undefined)time--;
	}
	while(IsAnyKeyPressed());
	while(AreKeysLeft())GetKey();
}